# -*- coding: utf-8 -*-
#for python2
# Module: xtutils_test
# version 2.4.5
# Author: HJ_G.
# Created on: 19.12.2021
# License: GPL v.3 https://www.gnu.org/copyleft/gpl.html

import os
import sys

from client import Client

if sys.version_info[0] == 3:
    # Python 3: 
    from urllib.parse import urlencode, parse_qsl
else:
    import urllib
    from urlparse import urlparse
    from urlparse import parse_qsl

# convert byte data to strings
def convert(data):
    if isinstance(data, bytes):
        return data.decode()
    if isinstance(data, dict):
        return dict(map(convert, data.items()))
    if isinstance(data, tuple):
        return tuple(map(convert, data))
    return data

def log(msg):
  plugin = "plugin.video.xtreamclient2"
  try:
    if isinstance(msg, unicode):
      msg = msg.encode('utf-8')
  except Exception:
    msg=msg
  print("[%s] %s" % (plugin, msg.__str__()))
    

def show_dialog(msg):
  print("######### Dialog #########")
  print(msg)

from xtreamcode_config import config

def getCWD():
  p = os.getcwd()
  return p

# disable in development!
def get_settings():
    log("get_settings...")
    global myconfig
    myconfig=config
    return myconfig

myclient=None
def start_connection():
    global myconfig
    global myclient
    myconfig=get_settings()
    url = myconfig["url"] + ":" + myconfig["port"] + "?username=" + myconfig["username"] + "&password=" + myconfig["password"]
    if myclient==None:
      myclient=Client(url)
    #print(client)
    return myclient


